package org.kodein.emoji.flags.flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _TransgenderFlag: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🏳️‍⚧️",
        description = "transgender flag",
        unicodeVersion = UnicodeVersion(13, 0),
        aliases = listOf("transgender-flag", "trans-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: flag: transgender flag.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.TransgenderFlag: Emoji get() = _TransgenderFlag

/**
 * Alias to emoji [TransgenderFlag] (Flags: flag: transgender flag).
*/
public val Emoji.Companion.TransFlag: Emoji get() = _TransgenderFlag
