package org.kodein.emoji.flags.flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WhiteFlag: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🏳️",
        description = "white flag",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("white-flag", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: flag: white flag.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WhiteFlag: Emoji get() = _WhiteFlag
