package org.kodein.emoji.objects.computer

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _OpticalDisk: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💿",
        description = "optical disk",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("optical-disk", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: computer: optical disk.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.OpticalDisk: Emoji get() = _OpticalDisk
