package org.kodein.emoji.people_body.family

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone2Emoji
import org.kodein.emoji.SkinTone2EmojiZWJImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _MenHoldingHands: SkinTone2Emoji = SkinTone2EmojiZWJImpl(
    details = Emoji.Details(
        string = "👬",
        description = "men holding hands",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("men-holding-hands", "holding-hands-men"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
    zwjTemplate = "👨‍🤝‍👨",
    zwjUnicodeVersion = UnicodeVersion(12, 1),
    sk21c = 2,
    sk22c = 8,
)

/**
 * Emoji People & Body: family: men holding hands.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MenHoldingHands: SkinTone2Emoji get() = _MenHoldingHands

/**
 * Alias to emoji [MenHoldingHands] (People & Body: family: men holding hands).
*/
public val Emoji.Companion.HoldingHandsMen: SkinTone2Emoji get() = _MenHoldingHands
