package org.kodein.emoji.people_body.person_activity

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WomenWithBunnyEars: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "👯‍♀",
        description = "women with bunny ears",
        unicodeVersion = UnicodeVersion(4, 0),
        aliases = listOf("women-with-bunny-ears", ),
        emoticons = listOf(),
        notoImageRatio = 0.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji People & Body: person-activity: women with bunny ears.
 *
 * Preferred type is: minimally-qualified.
*/
public val Emoji.Companion.WomenWithBunnyEars: Emoji get() = _WomenWithBunnyEars
