package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FaceWithDiagonalMouth: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🫤",
        description = "face with diagonal mouth",
        unicodeVersion = UnicodeVersion(14, 0),
        aliases = listOf("face-with-diagonal-mouth", "diagonal-mouth"),
        emoticons = listOf(":/"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-concerned: face with diagonal mouth.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FaceWithDiagonalMouth: Emoji get() = _FaceWithDiagonalMouth

/**
 * Alias to emoji [FaceWithDiagonalMouth] (Smileys & Emotion: face-concerned: face with diagonal mouth).
*/
public val Emoji.Companion.DiagonalMouth: Emoji get() = _FaceWithDiagonalMouth
