package org.kodein.emoji.smileys_emotion.face_hat

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFaceHat() {
    add(intArrayOf(0x1f920), _CowboyHatFace)
    add(intArrayOf(0x1f973), _PartyingFace)
    add(intArrayOf(0x1f978), _DisguisedFace)
}

internal suspend fun SequenceScope<Emoji>.yieldAllFaceHat() {
    yield(_CowboyHatFace)
    yield(_PartyingFace)
    yield(_DisguisedFace)
}

internal val countFaceHat = 3

/**
 * All Emoji of the Smileys & Emotion: face-hat subgroup.
*/
public fun Emoji.Companion.sequenceFaceHat(): Sequence<Emoji> =
    sequence { yieldAllFaceHat() }

/**
 * All Emoji of the Smileys & Emotion: face-hat subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listFaceHat(): List<Emoji> =
    ArrayList<Emoji>(countFaceHat).also { list -> sequenceFaceHat().forEach { list.add(it) } }

@Deprecated("Renamed listFaceHat.", replaceWith = ReplaceWith("listFaceHat()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allFaceHat(): List<Emoji> =
    listFaceHat()
