package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _LargeBlueDiamond: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔷",
        description = "large blue diamond",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("large-blue-diamond", "blue-diamond-large"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: geometric: large blue diamond.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.LargeBlueDiamond: Emoji get() = _LargeBlueDiamond

/**
 * Alias to emoji [LargeBlueDiamond] (Symbols: geometric: large blue diamond).
*/
public val Emoji.Companion.BlueDiamondLarge: Emoji get() = _LargeBlueDiamond
