package org.kodein.emoji.travel_places.transport_ground

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _OncomingPoliceCar: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🚔",
        description = "oncoming police car",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("oncoming-police-car", "police-car-front"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: transport-ground: oncoming police car.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.OncomingPoliceCar: Emoji get() = _OncomingPoliceCar

/**
 * Alias to emoji [OncomingPoliceCar] (Travel & Places: transport-ground: oncoming police car).
*/
public val Emoji.Companion.PoliceCarFront: Emoji get() = _OncomingPoliceCar
