package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagBolivia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇧🇴",
        description = "flag: Bolivia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-bolivia", "bolivia-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.4666667f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Bolivia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagBolivia: Emoji get() = _FlagBolivia

/**
 * Alias to emoji [FlagBolivia] (Flags: country-flag: flag: Bolivia).
*/
public val Emoji.Companion.BoliviaFlag: Emoji get() = _FlagBolivia
