package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagHonduras: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇭🇳",
        description = "flag: Honduras",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-honduras", "honduras-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Honduras.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagHonduras: Emoji get() = _FlagHonduras

/**
 * Alias to emoji [FlagHonduras] (Flags: country-flag: flag: Honduras).
*/
public val Emoji.Companion.HondurasFlag: Emoji get() = _FlagHonduras
