package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagNorfolkIsland: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇳🇫",
        description = "flag: Norfolk Island",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-norfolk-island", "norfolk-island-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Norfolk Island.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagNorfolkIsland: Emoji get() = _FlagNorfolkIsland

/**
 * Alias to emoji [FlagNorfolkIsland] (Flags: country-flag: flag: Norfolk Island).
*/
public val Emoji.Companion.NorfolkIslandFlag: Emoji get() = _FlagNorfolkIsland
