package org.kodein.emoji.objects.sound

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BellWithSlash: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔕",
        description = "bell with slash",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("bell-with-slash", "no-sound", "no-bell"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: sound: bell with slash.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BellWithSlash: Emoji get() = _BellWithSlash

/**
 * Alias to emoji [BellWithSlash] (Objects: sound: bell with slash).
*/
public val Emoji.Companion.NoSound: Emoji get() = _BellWithSlash

/**
 * Alias to emoji [BellWithSlash] (Objects: sound: bell with slash).
*/
public val Emoji.Companion.NoBell: Emoji get() = _BellWithSlash
