package org.kodein.emoji.symbols.arrow

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _LeftArrowCurvingRight: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "↪️",
        description = "left arrow curving right",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("left-arrow-curving-right", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: arrow: left arrow curving right.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.LeftArrowCurvingRight: Emoji get() = _LeftArrowCurvingRight
