package org.kodein.emoji.activities.event

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RedEnvelope: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🧧",
        description = "red envelope",
        unicodeVersion = UnicodeVersion(11, 0),
        aliases = listOf("red-envelope", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Activities: event: red envelope.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RedEnvelope: Emoji get() = _RedEnvelope
