package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagBritishVirginIslands: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇻🇬",
        description = "flag: British Virgin Islands",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-british-virgin-islands", "british-virgin-islands-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: British Virgin Islands.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagBritishVirginIslands: Emoji get() = _FlagBritishVirginIslands

/**
 * Alias to emoji [FlagBritishVirginIslands] (Flags: country-flag: flag: British Virgin Islands).
*/
public val Emoji.Companion.BritishVirginIslandsFlag: Emoji get() = _FlagBritishVirginIslands
