package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagChina: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇨🇳",
        description = "flag: China",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("flag-china", "china-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: China.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagChina: Emoji get() = _FlagChina

/**
 * Alias to emoji [FlagChina] (Flags: country-flag: flag: China).
*/
public val Emoji.Companion.ChinaFlag: Emoji get() = _FlagChina
