package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagGeorgia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇬🇪",
        description = "flag: Georgia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-georgia", "georgia-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Georgia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagGeorgia: Emoji get() = _FlagGeorgia

/**
 * Alias to emoji [FlagGeorgia] (Flags: country-flag: flag: Georgia).
*/
public val Emoji.Companion.GeorgiaFlag: Emoji get() = _FlagGeorgia
