package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagUzbekistan: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇺🇿",
        description = "flag: Uzbekistan",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-uzbekistan", "uzbekistan-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Uzbekistan.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagUzbekistan: Emoji get() = _FlagUzbekistan

/**
 * Alias to emoji [FlagUzbekistan] (Flags: country-flag: flag: Uzbekistan).
*/
public val Emoji.Companion.UzbekistanFlag: Emoji get() = _FlagUzbekistan
