package org.kodein.emoji.objects.office

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FileFolder: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📁",
        description = "file folder",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("file-folder", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: office: file folder.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FileFolder: Emoji get() = _FileFolder
