package org.kodein.emoji.people_body.family

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone2Emoji
import org.kodein.emoji.SkinTone2EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _CoupleWithHeartManMan: SkinTone2Emoji = SkinTone2EmojiImpl(
    details = Emoji.Details(
        string = "👨‍❤️‍👨",
        description = "couple with heart: man, man",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("couple-with-heart-man-man", "heart-with-man-and-man"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk21c = 2,
    sk22c = 8,
)

/**
 * Emoji People & Body: family: couple with heart: man, man.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CoupleWithHeartManMan: SkinTone2Emoji get() = _CoupleWithHeartManMan

/**
 * Alias to emoji [CoupleWithHeartManMan] (People & Body: family: couple with heart: man, man).
*/
public val Emoji.Companion.HeartWithManAndMan: SkinTone2Emoji get() = _CoupleWithHeartManMan
