package org.kodein.emoji.people_body.family

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFamily() {
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f91d, 0x200d, 0x1f9d1), _PeopleHoldingHands)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x1f91d, 0x200d, 0x1f9d1, 0x0), _PeopleHoldingHands, 1, 6)
    add(intArrayOf(0x1f46d), _WomenHoldingHands)
    addVariations(intArrayOf(0x1f46d, 0x0), _WomenHoldingHands, 1)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f91d, 0x200d, 0x1f469, 0x0), _WomenHoldingHands, 1, 6)
    add(intArrayOf(0x1f46c), _MenHoldingHands)
    addVariations(intArrayOf(0x1f46c, 0x0), _MenHoldingHands, 1)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x1f91d, 0x200d, 0x1f468, 0x0), _MenHoldingHands, 1, 6)
    add(intArrayOf(0x1f46b), _WomanAndManHoldingHands)
    addVariations(intArrayOf(0x1f46b, 0x0), _WomanAndManHoldingHands, 1)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x1f91d, 0x200d, 0x1f468, 0x0), _WomanAndManHoldingHands, 1, 6)
    add(intArrayOf(0x1f48f), _Kiss)
    addVariations(intArrayOf(0x1f48f, 0x0), _Kiss, 1)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x2764, 0xfe0f, 0x200d, 0x1f48b, 0x200d, 0x1f9d1, 0x0), _Kiss, 1, 9)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x2764, 0x200d, 0x1f48b, 0x200d, 0x1f9d1, 0x0), _Kiss, 1, 8)
    add(intArrayOf(0x1f469, 0x200d, 0x2764, 0xfe0f, 0x200d, 0x1f48b, 0x200d, 0x1f468), _KissWomanMan)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x2764, 0xfe0f, 0x200d, 0x1f48b, 0x200d, 0x1f468, 0x0), _KissWomanMan, 1, 9)
    add(intArrayOf(0x1f469, 0x200d, 0x2764, 0x200d, 0x1f48b, 0x200d, 0x1f468), _KissWomanMan)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x2764, 0x200d, 0x1f48b, 0x200d, 0x1f468, 0x0), _KissWomanMan, 1, 8)
    add(intArrayOf(0x1f468, 0x200d, 0x2764, 0xfe0f, 0x200d, 0x1f48b, 0x200d, 0x1f468), _KissManMan)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x2764, 0xfe0f, 0x200d, 0x1f48b, 0x200d, 0x1f468, 0x0), _KissManMan, 1, 9)
    add(intArrayOf(0x1f468, 0x200d, 0x2764, 0x200d, 0x1f48b, 0x200d, 0x1f468), _KissManMan)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x2764, 0x200d, 0x1f48b, 0x200d, 0x1f468, 0x0), _KissManMan, 1, 8)
    add(intArrayOf(0x1f469, 0x200d, 0x2764, 0xfe0f, 0x200d, 0x1f48b, 0x200d, 0x1f469), _KissWomanWoman)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x2764, 0xfe0f, 0x200d, 0x1f48b, 0x200d, 0x1f469, 0x0), _KissWomanWoman, 1, 9)
    add(intArrayOf(0x1f469, 0x200d, 0x2764, 0x200d, 0x1f48b, 0x200d, 0x1f469), _KissWomanWoman)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x2764, 0x200d, 0x1f48b, 0x200d, 0x1f469, 0x0), _KissWomanWoman, 1, 8)
    add(intArrayOf(0x1f491), _CoupleWithHeart)
    addVariations(intArrayOf(0x1f491, 0x0), _CoupleWithHeart, 1)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x2764, 0xfe0f, 0x200d, 0x1f9d1, 0x0), _CoupleWithHeart, 1, 7)
    addVariations(intArrayOf(0x1f9d1, 0x0, 0x200d, 0x2764, 0x200d, 0x1f9d1, 0x0), _CoupleWithHeart, 1, 6)
    add(intArrayOf(0x1f469, 0x200d, 0x2764, 0xfe0f, 0x200d, 0x1f468), _CoupleWithHeartWomanMan)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x2764, 0xfe0f, 0x200d, 0x1f468, 0x0), _CoupleWithHeartWomanMan, 1, 7)
    add(intArrayOf(0x1f469, 0x200d, 0x2764, 0x200d, 0x1f468), _CoupleWithHeartWomanMan)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x2764, 0x200d, 0x1f468, 0x0), _CoupleWithHeartWomanMan, 1, 6)
    add(intArrayOf(0x1f468, 0x200d, 0x2764, 0xfe0f, 0x200d, 0x1f468), _CoupleWithHeartManMan)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x2764, 0xfe0f, 0x200d, 0x1f468, 0x0), _CoupleWithHeartManMan, 1, 7)
    add(intArrayOf(0x1f468, 0x200d, 0x2764, 0x200d, 0x1f468), _CoupleWithHeartManMan)
    addVariations(intArrayOf(0x1f468, 0x0, 0x200d, 0x2764, 0x200d, 0x1f468, 0x0), _CoupleWithHeartManMan, 1, 6)
    add(intArrayOf(0x1f469, 0x200d, 0x2764, 0xfe0f, 0x200d, 0x1f469), _CoupleWithHeartWomanWoman)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x2764, 0xfe0f, 0x200d, 0x1f469, 0x0), _CoupleWithHeartWomanWoman, 1, 7)
    add(intArrayOf(0x1f469, 0x200d, 0x2764, 0x200d, 0x1f469), _CoupleWithHeartWomanWoman)
    addVariations(intArrayOf(0x1f469, 0x0, 0x200d, 0x2764, 0x200d, 0x1f469, 0x0), _CoupleWithHeartWomanWoman, 1, 6)
    add(intArrayOf(0x1f468, 0x200d, 0x1f469, 0x200d, 0x1f466), _FamilyManWomanBoy)
    add(intArrayOf(0x1f468, 0x200d, 0x1f469, 0x200d, 0x1f467), _FamilyManWomanGirl)
    add(intArrayOf(0x1f468, 0x200d, 0x1f469, 0x200d, 0x1f467, 0x200d, 0x1f466), _FamilyManWomanGirlBoy)
    add(intArrayOf(0x1f468, 0x200d, 0x1f469, 0x200d, 0x1f466, 0x200d, 0x1f466), _FamilyManWomanBoyBoy)
    add(intArrayOf(0x1f468, 0x200d, 0x1f469, 0x200d, 0x1f467, 0x200d, 0x1f467), _FamilyManWomanGirlGirl)
    add(intArrayOf(0x1f468, 0x200d, 0x1f468, 0x200d, 0x1f466), _FamilyManManBoy)
    add(intArrayOf(0x1f468, 0x200d, 0x1f468, 0x200d, 0x1f467), _FamilyManManGirl)
    add(intArrayOf(0x1f468, 0x200d, 0x1f468, 0x200d, 0x1f467, 0x200d, 0x1f466), _FamilyManManGirlBoy)
    add(intArrayOf(0x1f468, 0x200d, 0x1f468, 0x200d, 0x1f466, 0x200d, 0x1f466), _FamilyManManBoyBoy)
    add(intArrayOf(0x1f468, 0x200d, 0x1f468, 0x200d, 0x1f467, 0x200d, 0x1f467), _FamilyManManGirlGirl)
    add(intArrayOf(0x1f469, 0x200d, 0x1f469, 0x200d, 0x1f466), _FamilyWomanWomanBoy)
    add(intArrayOf(0x1f469, 0x200d, 0x1f469, 0x200d, 0x1f467), _FamilyWomanWomanGirl)
    add(intArrayOf(0x1f469, 0x200d, 0x1f469, 0x200d, 0x1f467, 0x200d, 0x1f466), _FamilyWomanWomanGirlBoy)
    add(intArrayOf(0x1f469, 0x200d, 0x1f469, 0x200d, 0x1f466, 0x200d, 0x1f466), _FamilyWomanWomanBoyBoy)
    add(intArrayOf(0x1f469, 0x200d, 0x1f469, 0x200d, 0x1f467, 0x200d, 0x1f467), _FamilyWomanWomanGirlGirl)
    add(intArrayOf(0x1f468, 0x200d, 0x1f466), _FamilyManBoy)
    add(intArrayOf(0x1f468, 0x200d, 0x1f466, 0x200d, 0x1f466), _FamilyManBoyBoy)
    add(intArrayOf(0x1f468, 0x200d, 0x1f467), _FamilyManGirl)
    add(intArrayOf(0x1f468, 0x200d, 0x1f467, 0x200d, 0x1f466), _FamilyManGirlBoy)
    add(intArrayOf(0x1f468, 0x200d, 0x1f467, 0x200d, 0x1f467), _FamilyManGirlGirl)
    add(intArrayOf(0x1f469, 0x200d, 0x1f466), _FamilyWomanBoy)
    add(intArrayOf(0x1f469, 0x200d, 0x1f466, 0x200d, 0x1f466), _FamilyWomanBoyBoy)
    add(intArrayOf(0x1f469, 0x200d, 0x1f467), _FamilyWomanGirl)
    add(intArrayOf(0x1f469, 0x200d, 0x1f467, 0x200d, 0x1f466), _FamilyWomanGirlBoy)
    add(intArrayOf(0x1f469, 0x200d, 0x1f467, 0x200d, 0x1f467), _FamilyWomanGirlGirl)
}

internal fun MutableList<Emoji>.addAllFamily() {
    add(_PeopleHoldingHands)
    add(_WomenHoldingHands)
    add(_MenHoldingHands)
    add(_WomanAndManHoldingHands)
    add(_Kiss)
    add(_KissWomanMan)
    add(_KissManMan)
    add(_KissWomanWoman)
    add(_CoupleWithHeart)
    add(_CoupleWithHeartWomanMan)
    add(_CoupleWithHeartManMan)
    add(_CoupleWithHeartWomanWoman)
    add(_FamilyManWomanBoy)
    add(_FamilyManWomanGirl)
    add(_FamilyManWomanGirlBoy)
    add(_FamilyManWomanBoyBoy)
    add(_FamilyManWomanGirlGirl)
    add(_FamilyManManBoy)
    add(_FamilyManManGirl)
    add(_FamilyManManGirlBoy)
    add(_FamilyManManBoyBoy)
    add(_FamilyManManGirlGirl)
    add(_FamilyWomanWomanBoy)
    add(_FamilyWomanWomanGirl)
    add(_FamilyWomanWomanGirlBoy)
    add(_FamilyWomanWomanBoyBoy)
    add(_FamilyWomanWomanGirlGirl)
    add(_FamilyManBoy)
    add(_FamilyManBoyBoy)
    add(_FamilyManGirl)
    add(_FamilyManGirlBoy)
    add(_FamilyManGirlGirl)
    add(_FamilyWomanBoy)
    add(_FamilyWomanBoyBoy)
    add(_FamilyWomanGirl)
    add(_FamilyWomanGirlBoy)
    add(_FamilyWomanGirlGirl)
}

/**
 * All Emoji of the People & Body: family subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allFamily(): List<Emoji> =
    ArrayList<Emoji>(37).apply { addAllFamily() }
