package org.kodein.emoji.people_body.person_gesture

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonPouting: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🙎",
        description = "person pouting",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("person-pouting", "pouting"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-gesture: person pouting.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonPouting: SkinTone1Emoji get() = _PersonPouting

/**
 * Alias to emoji [PersonPouting] (People & Body: person-gesture: person pouting).
*/
public val Emoji.Companion.Pouting: SkinTone1Emoji get() = _PersonPouting
