package org.kodein.emoji.smileys_emotion.face_costume

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFaceCostume() {
    add(intArrayOf(0x1f921), _ClownFace)
    add(intArrayOf(0x1f47b), _Ghost)
    add(intArrayOf(0x1f4a9), _PileOfPoo)
    add(intArrayOf(0x1f916), _Robot)
    add(intArrayOf(0x1f47d), _Alien)
    add(intArrayOf(0x1f47e), _AlienMonster)
    add(intArrayOf(0x1f479), _Ogre)
    add(intArrayOf(0x1f47a), _Goblin)
}

internal fun MutableList<Emoji>.addAllFaceCostume() {
    add(_ClownFace)
    add(_Ghost)
    add(_PileOfPoo)
    add(_Robot)
    add(_Alien)
    add(_AlienMonster)
    add(_Ogre)
    add(_Goblin)
}

/**
 * All Emoji of the Smileys & Emotion: face-costume subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allFaceCostume(): List<Emoji> =
    ArrayList<Emoji>(8).apply { addAllFaceCostume() }
