package org.kodein.emoji.smileys_emotion.heart

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _HeartOnFire: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "❤️‍🔥",
        description = "heart on fire",
        unicodeVersion = UnicodeVersion(13, 1),
        aliases = listOf("heart-on-fire", "fire-heart"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: heart: heart on fire.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.HeartOnFire: Emoji get() = _HeartOnFire

/**
 * Alias to emoji [HeartOnFire] (Smileys & Emotion: heart: heart on fire).
*/
public val Emoji.Companion.FireHeart: Emoji get() = _HeartOnFire
