package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _JapaneseMonthlyAmountButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🈷️",
        description = "Japanese “monthly amount” button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("japanese-monthly-amount-button", "monthly-amount"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: alphanum: Japanese “monthly amount” button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.JapaneseMonthlyAmountButton: Emoji get() = _JapaneseMonthlyAmountButton

/**
 * Alias to emoji [JapaneseMonthlyAmountButton] (Symbols: alphanum: Japanese “monthly amount” button).
*/
public val Emoji.Companion.MonthlyAmount: Emoji get() = _JapaneseMonthlyAmountButton
