package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BlackSquareButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔲",
        description = "black square button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("black-square-button", "button-black-square"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: geometric: black square button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BlackSquareButton: Emoji get() = _BlackSquareButton

/**
 * Alias to emoji [BlackSquareButton] (Symbols: geometric: black square button).
*/
public val Emoji.Companion.ButtonBlackSquare: Emoji get() = _BlackSquareButton
