package org.kodein.emoji.symbols.other_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _TridentEmblem: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔱",
        description = "trident emblem",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("trident-emblem", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: other-symbol: trident emblem.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.TridentEmblem: Emoji get() = _TridentEmblem
