package org.kodein.emoji.travel_places.time

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllTime() {
    add(intArrayOf(0x1f55b), _TwelveOclock)
    add(intArrayOf(0x1f567), _TwelveThirty)
    add(intArrayOf(0x1f550), _OneOclock)
    add(intArrayOf(0x1f55c), _OneThirty)
    add(intArrayOf(0x1f551), _TwoOclock)
    add(intArrayOf(0x1f55d), _TwoThirty)
    add(intArrayOf(0x1f552), _ThreeOclock)
    add(intArrayOf(0x1f55e), _ThreeThirty)
    add(intArrayOf(0x1f553), _FourOclock)
    add(intArrayOf(0x1f55f), _FourThirty)
    add(intArrayOf(0x1f554), _FiveOclock)
    add(intArrayOf(0x1f560), _FiveThirty)
    add(intArrayOf(0x1f555), _SixOclock)
    add(intArrayOf(0x1f561), _SixThirty)
    add(intArrayOf(0x1f556), _SevenOclock)
    add(intArrayOf(0x1f562), _SevenThirty)
    add(intArrayOf(0x1f557), _EightOclock)
    add(intArrayOf(0x1f563), _EightThirty)
    add(intArrayOf(0x1f558), _NineOclock)
    add(intArrayOf(0x1f564), _NineThirty)
    add(intArrayOf(0x1f559), _TenOclock)
    add(intArrayOf(0x1f565), _TenThirty)
    add(intArrayOf(0x1f55a), _ElevenOclock)
    add(intArrayOf(0x1f566), _ElevenThirty)
    add(intArrayOf(0x23f1, 0xfe0f), _Stopwatch)
    add(intArrayOf(0x23f1), _Stopwatch)
    add(intArrayOf(0x231a), _Watch)
    add(intArrayOf(0x1f570, 0xfe0f), _MantelpieceClock)
    add(intArrayOf(0x1f570), _MantelpieceClock)
    add(intArrayOf(0x231b), _HourglassDone)
    add(intArrayOf(0x23f3), _HourglassNotDone)
    add(intArrayOf(0x23f2, 0xfe0f), _TimerClock)
    add(intArrayOf(0x23f2), _TimerClock)
    add(intArrayOf(0x23f0), _AlarmClock)
}

internal fun MutableList<Emoji>.addAllTime() {
    add(_TwelveOclock)
    add(_TwelveThirty)
    add(_OneOclock)
    add(_OneThirty)
    add(_TwoOclock)
    add(_TwoThirty)
    add(_ThreeOclock)
    add(_ThreeThirty)
    add(_FourOclock)
    add(_FourThirty)
    add(_FiveOclock)
    add(_FiveThirty)
    add(_SixOclock)
    add(_SixThirty)
    add(_SevenOclock)
    add(_SevenThirty)
    add(_EightOclock)
    add(_EightThirty)
    add(_NineOclock)
    add(_NineThirty)
    add(_TenOclock)
    add(_TenThirty)
    add(_ElevenOclock)
    add(_ElevenThirty)
    add(_Stopwatch)
    add(_Watch)
    add(_MantelpieceClock)
    add(_HourglassDone)
    add(_HourglassNotDone)
    add(_TimerClock)
    add(_AlarmClock)
}

/**
 * All Emoji of the Travel & Places: time subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allTime(): List<Emoji> =
    ArrayList<Emoji>(31).apply { addAllTime() }
