package org.kodein.emoji.travel_places.transport_ground

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllTransportGround() {
    add(intArrayOf(0x1f6d1), _StopSign)
    add(intArrayOf(0x1f6a7), _Construction)
    add(intArrayOf(0x1f6a8), _PoliceCarLight)
    add(intArrayOf(0x26fd), _FuelPump)
    add(intArrayOf(0x1f6e2, 0xfe0f), _OilDrum)
    add(intArrayOf(0x1f6e2), _OilDrum)
    add(intArrayOf(0x1f6de), _Wheel)
    add(intArrayOf(0x1f68f), _BusStop)
    add(intArrayOf(0x1f687), _Metro)
    add(intArrayOf(0x1f6a5), _HorizontalTrafficLight)
    add(intArrayOf(0x1f6a6), _VerticalTrafficLight)
    add(intArrayOf(0x1f6f4), _KickScooter)
    add(intArrayOf(0x1f9bd), _ManualWheelchair)
    add(intArrayOf(0x1f9bc), _MotorizedWheelchair)
    add(intArrayOf(0x1f6b2), _Bicycle)
    add(intArrayOf(0x1f6f5), _MotorScooter)
    add(intArrayOf(0x1f3cd, 0xfe0f), _Motorcycle)
    add(intArrayOf(0x1f3cd), _Motorcycle)
    add(intArrayOf(0x1f699), _SportUtilityVehicle)
    add(intArrayOf(0x1f697), _Automobile)
    add(intArrayOf(0x1f6fb), _PickupTruck)
    add(intArrayOf(0x1f690), _Minibus)
    add(intArrayOf(0x1f69a), _DeliveryTruck)
    add(intArrayOf(0x1f69b), _ArticulatedLorry)
    add(intArrayOf(0x1f69c), _Tractor)
    add(intArrayOf(0x1f3ce, 0xfe0f), _RacingCar)
    add(intArrayOf(0x1f3ce), _RacingCar)
    add(intArrayOf(0x1f692), _FireEngine)
    add(intArrayOf(0x1f691), _Ambulance)
    add(intArrayOf(0x1f693), _PoliceCar)
    add(intArrayOf(0x1f695), _Taxi)
    add(intArrayOf(0x1f6fa), _AutoRickshaw)
    add(intArrayOf(0x1f68c), _Bus)
    add(intArrayOf(0x1f688), _LightRail)
    add(intArrayOf(0x1f69d), _Monorail)
    add(intArrayOf(0x1f685), _BulletTrain)
    add(intArrayOf(0x1f684), _HighSpeedTrain)
    add(intArrayOf(0x1f682), _Locomotive)
    add(intArrayOf(0x1f683), _RailwayCar)
    add(intArrayOf(0x1f68b), _TramCar)
    add(intArrayOf(0x1f68e), _Trolleybus)
    add(intArrayOf(0x1f69e), _MountainRailway)
    add(intArrayOf(0x1f68a), _Tram)
    add(intArrayOf(0x1f689), _Station)
    add(intArrayOf(0x1f68d), _OncomingBus)
    add(intArrayOf(0x1f694), _OncomingPoliceCar)
    add(intArrayOf(0x1f698), _OncomingAutomobile)
    add(intArrayOf(0x1f696), _OncomingTaxi)
    add(intArrayOf(0x1f686), _Train)
    add(intArrayOf(0x1f6e4, 0xfe0f), _RailwayTrack)
    add(intArrayOf(0x1f6e4), _RailwayTrack)
    add(intArrayOf(0x1f6e3, 0xfe0f), _Motorway)
    add(intArrayOf(0x1f6e3), _Motorway)
    add(intArrayOf(0x1f6fc), _RollerSkate)
    add(intArrayOf(0x1f6f9), _Skateboard)
}

internal fun MutableList<Emoji>.addAllTransportGround() {
    add(_StopSign)
    add(_Construction)
    add(_PoliceCarLight)
    add(_FuelPump)
    add(_OilDrum)
    add(_Wheel)
    add(_BusStop)
    add(_Metro)
    add(_HorizontalTrafficLight)
    add(_VerticalTrafficLight)
    add(_KickScooter)
    add(_ManualWheelchair)
    add(_MotorizedWheelchair)
    add(_Bicycle)
    add(_MotorScooter)
    add(_Motorcycle)
    add(_SportUtilityVehicle)
    add(_Automobile)
    add(_PickupTruck)
    add(_Minibus)
    add(_DeliveryTruck)
    add(_ArticulatedLorry)
    add(_Tractor)
    add(_RacingCar)
    add(_FireEngine)
    add(_Ambulance)
    add(_PoliceCar)
    add(_Taxi)
    add(_AutoRickshaw)
    add(_Bus)
    add(_LightRail)
    add(_Monorail)
    add(_BulletTrain)
    add(_HighSpeedTrain)
    add(_Locomotive)
    add(_RailwayCar)
    add(_TramCar)
    add(_Trolleybus)
    add(_MountainRailway)
    add(_Tram)
    add(_Station)
    add(_OncomingBus)
    add(_OncomingPoliceCar)
    add(_OncomingAutomobile)
    add(_OncomingTaxi)
    add(_Train)
    add(_RailwayTrack)
    add(_Motorway)
    add(_RollerSkate)
    add(_Skateboard)
}

/**
 * All Emoji of the Travel & Places: transport-ground subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allTransportGround(): List<Emoji> =
    ArrayList<Emoji>(50).apply { addAllTransportGround() }
