package org.kodein.emoji.activities.event

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ReminderRibbon: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎗️",
        description = "reminder ribbon",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("reminder-ribbon", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Activities: event: reminder ribbon.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ReminderRibbon: Emoji get() = _ReminderRibbon
