package org.kodein.emoji.objects.tool

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Boomerang: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🪃",
        description = "boomerang",
        unicodeVersion = UnicodeVersion(13, 0),
        aliases = listOf("boomerang", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: tool: boomerang.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Boomerang: Emoji get() = _Boomerang
