package org.kodein.emoji.people_body.person

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonBald: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🧑‍🦲",
        description = "person: bald",
        unicodeVersion = UnicodeVersion(12, 1),
        aliases = listOf("person-bald", "bald"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person: person: bald.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonBald: SkinTone1Emoji get() = _PersonBald

/**
 * Alias to emoji [PersonBald] (People & Body: person: person: bald).
*/
public val Emoji.Companion.Bald: SkinTone1Emoji get() = _PersonBald
