package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PleadingFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🥺",
        description = "pleading face",
        unicodeVersion = UnicodeVersion(11, 0),
        aliases = listOf("pleading-face", "pleading"),
        emoticons = listOf("◕﹏◕"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-concerned: pleading face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PleadingFace: Emoji get() = _PleadingFace

/**
 * Alias to emoji [PleadingFace] (Smileys & Emotion: face-concerned: pleading face).
*/
public val Emoji.Companion.Pleading: Emoji get() = _PleadingFace
