package org.kodein.emoji.smileys_emotion.face_smiling

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _UpsideDownFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🙃",
        description = "upside-down face",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("upside-down-face", ),
        emoticons = listOf("(:"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-smiling: upside-down face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.UpsideDownFace: Emoji get() = _UpsideDownFace
