package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CircledM: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "Ⓜ️",
        description = "circled M",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("circled-m", "metro-sign"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: alphanum: circled M.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CircledM: Emoji get() = _CircledM

/**
 * Alias to emoji [CircledM] (Symbols: alphanum: circled M).
*/
public val Emoji.Companion.MetroSign: Emoji get() = _CircledM
