package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _LargeOrangeDiamond: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔶",
        description = "large orange diamond",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("large-orange-diamond", "diamond-orange-large"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: geometric: large orange diamond.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.LargeOrangeDiamond: Emoji get() = _LargeOrangeDiamond

/**
 * Alias to emoji [LargeOrangeDiamond] (Symbols: geometric: large orange diamond).
*/
public val Emoji.Companion.DiamondOrangeLarge: Emoji get() = _LargeOrangeDiamond
