package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagColombia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇨🇴",
        description = "flag: Colombia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-colombia", "colombia-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Colombia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagColombia: Emoji get() = _FlagColombia

/**
 * Alias to emoji [FlagColombia] (Flags: country-flag: flag: Colombia).
*/
public val Emoji.Companion.ColombiaFlag: Emoji get() = _FlagColombia
