package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagGuam: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇬🇺",
        description = "flag: Guam",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-guam", "guam-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.8626609f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Guam.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagGuam: Emoji get() = _FlagGuam

/**
 * Alias to emoji [FlagGuam] (Flags: country-flag: flag: Guam).
*/
public val Emoji.Companion.GuamFlag: Emoji get() = _FlagGuam
