package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagNepal: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇳🇵",
        description = "flag: Nepal",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-nepal", "nepal-flag"),
        emoticons = listOf(),
        notoImageRatio = 0.82033896f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Nepal.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagNepal: Emoji get() = _FlagNepal

/**
 * Alias to emoji [FlagNepal] (Flags: country-flag: flag: Nepal).
*/
public val Emoji.Companion.NepalFlag: Emoji get() = _FlagNepal
