package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagTurksCaicosIslands: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇹🇨",
        description = "flag: Turks & Caicos Islands",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-turks-caicos-islands", "turks-caicos-islands-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Turks & Caicos Islands.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagTurksCaicosIslands: Emoji get() = _FlagTurksCaicosIslands

/**
 * Alias to emoji [FlagTurksCaicosIslands] (Flags: country-flag: flag: Turks & Caicos Islands).
*/
public val Emoji.Companion.TurksCaicosIslandsFlag: Emoji get() = _FlagTurksCaicosIslands
