package org.kodein.emoji.objects.book_paper

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _OpenBook: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📖",
        description = "open book",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("open-book", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: book-paper: open book.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.OpenBook: Emoji get() = _OpenBook
