package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RunningShoe: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "👟",
        description = "running shoe",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("running-shoe", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: clothing: running shoe.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RunningShoe: Emoji get() = _RunningShoe
