package org.kodein.emoji.objects.money

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ChartIncreasingWithYen: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💹",
        description = "chart increasing with yen",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("chart-increasing-with-yen", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: money: chart increasing with yen.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ChartIncreasingWithYen: Emoji get() = _ChartIncreasingWithYen
