package org.kodein.emoji.objects.money

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _YenBanknote: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💴",
        description = "yen banknote",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("yen-banknote", "yen"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: money: yen banknote.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.YenBanknote: Emoji get() = _YenBanknote

/**
 * Alias to emoji [YenBanknote] (Objects: money: yen banknote).
*/
public val Emoji.Companion.Yen: Emoji get() = _YenBanknote
