package org.kodein.emoji.people_body.body_parts

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _EarWithHearingAid: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🦻",
        description = "ear with hearing aid",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("ear-with-hearing-aid", "hearing-aid"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: body-parts: ear with hearing aid.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.EarWithHearingAid: SkinTone1Emoji get() = _EarWithHearingAid

/**
 * Alias to emoji [EarWithHearingAid] (People & Body: body-parts: ear with hearing aid).
*/
public val Emoji.Companion.HearingAid: SkinTone1Emoji get() = _EarWithHearingAid
