package org.kodein.emoji.people_body.family

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FamilyManGirl: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "👨‍👧",
        description = "family: man, girl",
        unicodeVersion = UnicodeVersion(4, 0),
        aliases = listOf("family-man-girl", ),
        emoticons = listOf(),
        notoImageRatio = 0.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji People & Body: family: family: man, girl.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FamilyManGirl: Emoji get() = _FamilyManGirl
