package org.kodein.emoji.people_body.family

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FamilyManWomanGirl: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "👨‍👩‍👧",
        description = "family: man, woman, girl",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("family-man-woman-girl", ),
        emoticons = listOf(),
        notoImageRatio = 0.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji People & Body: family: family: man, woman, girl.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FamilyManWomanGirl: Emoji get() = _FamilyManWomanGirl
