package org.kodein.emoji.people_body.family

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FamilyWomanWomanGirl: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "👩‍👩‍👧",
        description = "family: woman, woman, girl",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("family-woman-woman-girl", ),
        emoticons = listOf(),
        notoImageRatio = 0.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji People & Body: family: family: woman, woman, girl.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FamilyWomanWomanGirl: Emoji get() = _FamilyWomanWomanGirl
