package org.kodein.emoji.people_body.hand_single_finger

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _BackhandIndexPointingRight: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "👉",
        description = "backhand index pointing right",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("backhand-index-pointing-right", "point-right"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: hand-single-finger: backhand index pointing right.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BackhandIndexPointingRight: SkinTone1Emoji get() = _BackhandIndexPointingRight

/**
 * Alias to emoji [BackhandIndexPointingRight] (People & Body: hand-single-finger: backhand index pointing right).
*/
public val Emoji.Companion.PointRight: SkinTone1Emoji get() = _BackhandIndexPointingRight
